/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.SyncValueContainerMessage;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IValueContainerServerHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    default public void handleSyncValueContainerMessage(SyncValueContainerMessage msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        ctx.enqueueWork(() -> {
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            BlockPos pos = msg.getPos();
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ValueContainer) && !(world.func_180495_p(pos).func_177230_c() instanceof ValueContainer)) {
                LOGGER.error("Tile Entity or Block at '" + pos + "' was expected to be a ValueContainer, but it was " + te + "!");
                return;
            }
            if (!player.func_195070_dx()) {
                LOGGER.error("Player with id " + player.func_110124_au() + " does not have the permission to modify value containers!");
                return;
            }
            ValueContainer.deserialize(world, pos, te instanceof ValueContainer ? (ValueContainer)te : (ValueContainer)world.func_180495_p(pos).func_177230_c(), msg.getData());
        });
    }
}

